package pt.caf_pbs.schooldiskapi.model;

import pt.caf_pbs.schooldiskapi.dto.SubjectDTO;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

import java.io.Serializable;

public class Subject implements Serializable {
    private String initials;
    private String designation;

    public Subject(String initials, String designation) {
        setInitials(initials);
        this.designation = designation;
    }

    public Subject(Subject obj) {
        setInitials(obj.initials);
        this.designation = obj.designation;
    }

    public Subject(SubjectDTO obj) {
        setInitials(obj.getInitials());
        this.designation = obj.getDesignation();
    }

    private boolean isInitialsValid(String initials) {
        return initials.length() >= 4;
    }

    public String getInitials() {
        return initials;
    }

    public void setInitials(String initials) {
        if (isInitialsValid(initials)) {
            this.initials = initials;
        } else {

            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
    }

    public String getDesignation() {
        return designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public boolean isEqualTo(Subject obj) {
        return this.initials.equals(obj.initials);
    }

    public boolean isEqualTo(String str) {
        return this.initials.equals(str);
    }
}
